<?php

namespace MediaWiki\Extension\WikiSEO\Tests\Generator\Plugin;

use MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter;
use MediaWiki\Extension\WikiSEO\Tests\Generator\GeneratorTestBase;

/**
 * @group Database
 */
class TwitterTest extends GeneratorTestBase {
	/**
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter::init
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter::addMetadata
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\OpenGraph::addMetadata
	 */
	public function testAddMetadata() {
		$metadata = [
			'description'  => 'Example Description',
			'keywords'     => 'Keyword 1, Keyword 2',
			'twitter_site' => 'example',
		];

		$out = $this->newInstance();

		$generator = new Twitter();
		$generator->init( $metadata, $out );
		$generator->addMetadata();

		$this->assertArraySubmapSame( [ [
			'twitter:site', 'example'
		] ], $out->getMetaTags() );
	}

	/**
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter::init
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter::addTwitterSiteHandleTag
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\AbstractBaseGenerator::getConfigValue
	 */
	public function testAddTwitterSiteHandle() {
		$this->overrideConfigValue( 'TwitterSiteHandle', '@TestKey' );

		$out = $this->newInstance();

		$generator = new Twitter();
		$generator->init( [], $out );
		$generator->addMetadata();

		$this->assertArraySubmapSame( [ [
			'twitter:site', '@TestKey'
		] ], $out->getMetaTags() );
	}

	/**
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter::init
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter::addTwitterSiteHandleTag
	 */
	public function testIgnoreMetaIfGlobal() {
		$this->overrideConfigValue( 'TwitterSiteHandle', '@TestKey' );

		$out = $this->newInstance();

		$generator = new Twitter();
		$generator->init( [ 'twitter_site' => '@NotAdded' ], $out );
		$generator->addMetadata();

		$this->assertArraySubmapSame( [ [
			'twitter:site', '@TestKey'
		] ], $out->getMetaTags() );
	}

	/**
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter::addMetadata
	 */
	public function testDefaultSummaryType() {
		$out = $this->newInstance();

		$generator = new Twitter();
		$generator->init( [], $out );
		$generator->addMetadata();

		$this->assertArraySubmapSame( [ [
			'twitter:card', 'summary_large_image'
		] ], $out->getMetaTags() );
	}

	/**
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter::addMetadata
	 */
	public function testSummaryType() {
		// Unset default image if set
		$this->overrideConfigValue( 'TwitterCardType', 'summary' );

		$out = $this->newInstance();

		$generator = new Twitter();
		$generator->init( [], $out );
		$generator->addMetadata();

		$this->assertArraySubmapSame( [ [
			'twitter:card', 'summary'
		] ], $out->getMetaTags() );
	}

	/**
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter::addMetadata
	 */
	public function testSummaryTypeOverride() {
		// Unset default image if set
		$this->overrideConfigValue( 'TwitterCardType', 'summary' );

		$out = $this->newInstance();

		$generator = new Twitter();
		$generator->init( [ 'twitter_card' => 'override_card' ], $out );
		$generator->addMetadata();

		$this->assertArraySubmapSame( [ [
			'twitter:card', 'override_card'
		] ], $out->getMetaTags() );
	}

	/**
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter::addMetadata
	 * @covers \MediaWiki\Extension\WikiSEO\Generator\Plugins\Twitter::addTwitterSiteHandleTag
	 */
	public function testHandleNotSet() {
		// Unset default image if set
		$this->overrideConfigValue( 'TwitterSiteHandle', null );

		$out = $this->newInstance();

		$generator = new Twitter();
		$generator->init( [], $out );
		$generator->addMetadata();

		self::assertArrayNotHasKey( 'twitter:site', $out->getHeadItemsArray() );
	}
}
