( function ( $ ) {
	'use strict';

	var urPhonetic = {
		id: 'ur-phonetic',
		name: 'صوتی',
		description: 'Phonetic keyboard for Urdu script',
		date: '2013-02-18',
		URL: 'http://cvs.savannah.gnu.org/viewvc/m17n-contrib/im/ur-phonetic.mim?root=m17n&view=markup',
		author: 'Parag Nemade',
		license: 'GPLv3',
		version: '1.0',
		patterns: [
			/* fathatan */ [ '\\~', 'ً' ],
			/* kasratan */ [ '\\`', 'ٍ' ],
			[ '!', '!' ],
			[ '\\@', '@' ],
			[ '\\#', '#' ],
			[ '\\$', '$' ],
			[ '\\%', '%' ],
			/* gol he with hamza */ [ '\\^', 'ۂ' ],
			[ '\\&', '&' ],
			/* dammatan */ [ '\\*', '*' ],
			[ '\\(', ')' ],
			[ '\\)', '(' ],
			/* tatwel */ [ '_', 'ـ' ],
			/* Alef with hamza above */ [ '\\-', 'أ' ],
			/* madda*/ [ '\\+', 'ٓ' ],
			/* small madda */ [ '\\=', 'ۤ' ],
			[ 'Q', 'ﷺ' ],
			[ 'q', 'ق' ],
			[ 'W', 'ؤ' ],
			[ 'w', 'و' ],
			[ 'E', 'ؑ' ],
			[ 'e', 'ع' ],
			[ 'R', 'ڑ' ],
			[ 'r', 'ر' ],
			[ 'T', 'ٹ' ],
			[ 't', 'ت' ],
			[ 'Y', '\u0601' ],
			[ 'y', 'ے' ],
			[ 'U', 'ء' ],
			/* Yeh with hamza above */ [ 'u', 'ئ' ],
			/* superscript alef */ [ 'I', 'ٰ' ],
			[ 'i', 'ی' ],
			/* Teh marbuta goal */ [ 'O', 'ۃ' ],
			[ 'o', 'ہ' ],
			/* damma */ [ 'P', 'ُ' ],
			[ 'p', 'پ' ],
			/* inverted damma */ [ '\\{', 'ٗ' ],
			/* dammatan */ [ '\\[', 'ٌ' ],
			/* shadd */ [ '\\}', 'ّ' ],
			/* Sukun */ [ '\\]', 'ْ' ],
			/* alif madda */ [ 'A', 'آ' ],
			[ 'a', 'ا' ],
			[ 'S', 'ص' ],
			[ 's', 'س' ],
			[ 'D', 'ڈ' ],
			[ 'd', 'د' ],
			/* subscript khari zer */ [ 'F', 'ٖ' ],
			[ 'f', 'ف' ],
			[ 'G', 'غ' ],
			[ 'g', 'گ' ],
			[ 'H', 'ح' ],
			[ 'h', 'ھ' ],
			[ 'J', 'ض' ],
			[ 'j', 'ج' ],
			[ 'K', 'خ' ],
			[ 'k', 'ک' ],
			/* radi allah */ [ 'L', '\u0613' ],
			[ 'l', 'ل' ],
			[ '\\:', ':' ],
			/* Arabic semicolon */ [ ';', '؛' ],
			[ "\\'", "'" ],
			[ '\\"', '"' ],
			/* takhallus */ [ '\\|', 'ؔ' ],
			/* verse sign */ [ '\\', '؎' ],
			[ 'Z', 'ذ' ],
			[ 'z', 'ز' ],
			[ 'X', 'ژ' ],
			[ 'x', 'ش' ],
			[ 'C', 'ث' ],
			[ 'c', 'چ' ],
			[ 'V', 'ظ' ],
			[ 'v', 'ط' ],
			/* rahmatullah */ [ 'B', 'ؒ' ],
			[ 'b', 'ب' ],
			[ 'N', 'ں' ],
			[ 'n', 'ن' ],
			/* swad sign */ [ 'M', 'ؐ' ],
			[ 'm', 'م' ],
			/* kasra */ [ '\\<', 'ِ' ],
			[ ',', '،' ],
			/* fatha */ [ '\\>', 'َ' ],
			/* Arabic full stop */ [ '\\.', '۔' ],
			/* Arabic question mark */ [ '\\?', '؟' ] ]
	};

	$.ime.register( urPhonetic );
}( jQuery ) );
