( function ( $ ) {
	'use strict';

	var teInScript2 = {
		id: 'te-inscript2',
		name: 'ఇన్\u200dస్క్రిప్ట్ 2',
		description: 'Enhanced InScript keyboard for Telugu script',
		date: '2013-01-16',
		URL: 'https://www.mediawiki.org/wiki/Special:MyLanguage/Help:Extension:UniversalLanguageSelector/Input_methods/te-inscript2',
		author: 'Parag Nemade',
		license: 'GPLv3',
		version: '1.0',
		patterns: [
			[ '1', '౧' ],
			[ '2', '౨' ],
			[ '3', '౩' ],
			[ '4', '౪' ],
			[ '5', '౫' ],
			[ '6', '౬' ],
			[ '7', '౭' ],
			[ '8', '౮' ],
			[ '\\(', '(' ],
			[ '9', '౯' ],
			[ '\\)', ')' ],
			[ '0', '౦' ],
			[ '\\_', 'ః' ],
			[ '\\-', '-' ],
			[ '\\+', 'ఋ' ],
			[ '\\=', 'ృ' ],
			[ 'Q', 'ఔ' ],
			[ 'q', 'ౌ' ],
			[ 'W', 'ఐ' ],
			[ 'w', 'ై' ],
			[ 'E', 'ఆ' ],
			[ 'e', 'ా' ],
			[ 'R', 'ఈ' ],
			[ 'r', 'ీ' ],
			[ 'T', 'ఊ' ],
			[ 't', 'ూ' ],
			[ 'Y', 'భ' ],
			[ 'y', 'బ' ],
			[ 'U', 'ఙ' ],
			[ 'u', 'హ' ],
			[ 'I', 'ఘ' ],
			[ 'i', 'గ' ],
			[ 'O', 'ధ' ],
			[ 'o', 'ద' ],
			[ 'P', 'ఝ' ],
			[ 'p', 'జ' ],
			[ '\\{', 'ఢ' ],
			[ '\\[', 'డ' ],
			[ '\\}', 'ఞ' ],
			[ 'A', 'ఓ' ],
			[ 'a', 'ో' ],
			[ 'S', 'ఏ' ],
			[ 's', 'ే' ],
			[ 'D', 'అ' ],
			[ 'd', '్' ],
			[ 'F', 'ఇ' ],
			[ 'f', 'ి' ],
			[ 'G', 'ఉ' ],
			[ 'g', 'ు' ],
			[ 'H', 'ఫ' ],
			[ 'h', 'ప' ],
			[ 'J', 'ఱ' ],
			[ 'j', 'ర' ],
			[ 'K', 'ఖ' ],
			[ 'k', 'క' ],
			[ 'L', 'థ' ],
			[ 'l', 'త' ],
			[ ':', 'ఛ' ],
			[ ';', 'చ' ],
			[ '"', 'ఠ' ],
			[ '\\\'', 'ట' ],
			[ '\\~', 'ఒ' ],
			[ '\\`', 'ొ' ],
			[ 'Z', 'ఎ' ],
			[ 'z', 'ె' ],
			[ 'X', 'ఁ' ],
			[ 'x', 'ం' ],
			[ 'C', 'ణ' ],
			[ 'c', 'మ' ],
			[ 'v', 'న' ],
			[ 'b', 'వ' ],
			[ 'N', 'ళ' ],
			[ 'n', 'ల' ],
			[ 'M', 'శ' ],
			[ 'm', 'స' ],
			[ '\\<', 'ష' ],
			[ ',', ',' ],
			[ '\\>', '।' ],
			[ '\\.', '.' ],
			[ '/', 'య' ],
			[ '\\%', 'జ్ఞ' ],
			[ '\\^', 'త్ర' ],
			[ '\\&', 'క్ష' ],
			[ '\\*', 'శ్ర' ]
		],
		patterns_x: [
			[ '\\!', '౹' ],
			[ '\\@', '౼' ],
			[ '\\#', '౺' ],
			[ '\\$', '౽' ],
			[ '4', '₹' ],
			[ '\\%', '౻' ],
			[ '\\^', '౾' ],
			[ '1', '\u200d' ],
			[ '2', '\u200c' ],
			[ '0', '౸' ],
			[ '\\-', '౿' ],
			[ '\\+', 'ౠ' ],
			[ '\\=', 'ౄ' ],
			[ 'R', 'ౣ' ],
			[ 'r', 'ౡ' ],
			[ 'p', 'ౙ' ],
			[ 'F', 'ఌ' ],
			[ 'f', 'ౢ' ],
			[ ';', 'ౘ' ],
			[ 'Z', 'ౖ' ],
			[ 'z', 'ౕ' ],
			[ '\\>', 'ఽ' ],
			[ '\\.', '॥' ]
		]
	};

	$.ime.register( teInScript2 );
}( jQuery ) );
