( function ( $ ) {
	'use strict';

	var sdhKbd = {
		id: 'sdh-kbd',
		name: 'کوردی خوارگ',
		description: 'Southern Kurdish Keyboard Layout',
		date: '2015-05-03',
		URL: 'https://www.mediawiki.org/wiki/Special:MyLanguage/Help:Extension:UniversalLanguageSelector/Input_methods/sdh-kbd',
		author: 'Mjbmr',
		license: 'GPLv3',
		version: '1.0',
		patterns: [
			[ '`', '\u200c' ],
			[ '1', '١' ],
			[ '2', '٢' ],
			[ '3', '٣' ],
			[ '4', '٤' ],
			[ '5', '٥' ],
			[ '6', '۶' ],
			[ '7', '٧' ],
			[ '8', '٨' ],
			[ '9', '٩' ],
			[ '0', '٠' ],

			[ 'q', 'ض' ],
			[ 'w', 'ص' ],
			[ 'e', 'ث' ],
			[ 'r', 'ق' ],
			[ 't', 'ف' ],
			[ 'y', 'غ' ],
			[ 'u', 'ع' ],
			[ 'i', 'ھ' ],
			[ 'o', 'خ' ],
			[ 'p', 'ح' ],
			[ '\\[', 'ج' ],
			[ '\\]', 'چ' ],

			[ 'a', 'ش' ],
			[ 's', 'س' ],
			[ 'd', 'ی' ],
			[ 'f', 'ب' ],
			[ 'g', 'ل' ],
			[ 'h', 'ا' ],
			[ 'j', 'ت' ],
			[ 'k', 'ن' ],
			[ 'l', 'م' ],
			[ ';', 'ک' ],
			[ '\'', 'گ' ],

			[ 'z', 'ظ' ],
			[ 'x', 'ط' ],
			[ 'c', 'ز' ],
			[ 'v', 'ر' ],
			[ 'b', 'ذ' ],
			[ 'n', 'د' ],
			[ 'm', 'پ' ],
			[ ',', 'و' ],

			[ '~', '÷' ],
			[ '@', '٬' ],
			[ '#', '٫' ],
			[ '%', '٪' ],
			[ '\\^', '×' ],
			[ '&', '،' ],
			[ '\\(', ')' ],
			[ '\\)', '(' ],
			[ '_', 'ـ' ],

			[ 'Q', 'ْ' ],
			[ 'W', 'وو' ],
			[ 'E', 'ڤ' ],
			[ 'R', 'ً' ],
			[ 'T', 'ۊ' ],
			[ 'Y', 'ئ' ],
			[ 'U', 'ە' ],
			[ 'I', 'ّ' ],
			[ 'O', ']' ],
			[ 'P', '[' ],
			[ '\\{', '}' ],
			[ '\\}', '{' ],

			[ 'A', 'ؤ' ],
			[ 'S', 'ئ' ],
			[ 'D', 'ێ' ],
			[ 'F', 'إ' ],
			[ 'G', 'أ' ],
			[ 'H', 'آ' ],
			[ 'J', 'ة' ],
			[ 'K', '»' ],
			[ 'L', '«' ],
			[ '"', '؛' ],

			[ 'Z', 'ۆ' ],
			[ 'X', 'ط' ],
			[ 'C', 'ژ' ],
			[ 'V', 'ڕ' ],
			[ 'B', 'ڵ' ],
			[ 'N', 'ٔ' ],
			[ 'M', 'ء' ],
			[ '<', '>' ],
			[ '>', '<' ],
			[ '\\?', '؟' ]
		]
	};

	$.ime.register( sdhKbd );
}( jQuery ) );
