( function ( $ ) {
	'use strict';

	var satSarjomBaha = {
		id: 'sat-sarjom-baha',
		name: 'Sarjom Baha',
		description: 'Phonetic Ol Chiki keyboard, Sarjom Baha for Santali language',
		date: '2016-03-29',
		URL: 'https://www.mediawiki.org/wiki/Special:MyLanguage/Help:Extension:UniversalLanguageSelector/Input_methods/sat-Sarjom_baha',
		author: 'Jnanaranjan Sahu',
		license: 'GPLv3',
		version: '1.01',
		patterns: [
			[ 'a', 'ᱟ' ],
			[ 'b', 'ᱵ' ],
			[ 'c', 'ᱪ' ],
			[ 'd', 'ᱰ' ],
			[ 'e', 'ᱮ' ],
			[ 'f', 'ᱝ' ],
			[ 'g', 'ᱜ' ],
			[ 'h', 'ᱦ' ],
			[ 'i', 'ᱤ' ],
			[ 'j', 'ᱡ' ],
			[ 'k', 'ᱠ' ],
			[ 'l', 'ᱞ' ],
			[ 'm', 'ᱢ' ],
			[ 'n', 'ᱱ' ],
			[ 'o', 'ᱚ' ],
			[ 'p', 'ᱯ' ],
			[ 'q', 'ᱧ' ],
			[ 'r', 'ᱨ' ],
			[ 's', 'ᱥ' ],
			[ 't', 'ᱴ' ],
			[ 'u', 'ᱩ' ],
			[ 'v', 'ᱶ' ],
			[ 'w', 'ᱣ' ],
			[ 'x', 'ᱽ' ],
			[ 'y', 'ᱭ' ],
			[ 'z', 'ᱲ' ],
			[ 'A', 'ᱟ' ],
			[ 'B', 'ᱵ' ],
			[ 'C', 'ᱪ' ],
			[ 'D', 'ᱫ' ],
			[ 'E', 'ᱮ' ],
			[ 'F', 'ᱝ' ],
			[ 'G', 'ᱜ' ],
			[ 'H', 'ᱷ' ],
			[ 'I', '᱾' ],
			[ 'J', 'ᱡ' ],
			[ 'K', 'ᱠ' ],
			[ 'L', '᱿' ],
			[ 'M', 'ᱬ' ],
			[ 'N', 'ᱸ' ],
			[ 'O', 'ᱳ' ],
			[ 'P', 'ᱯ' ],
			[ 'Q', 'ᱻ' ],
			[ 'R', 'ᱨ' ],
			[ 'S', 'ᱥ' ],
			[ 'T', 'ᱛ' ],
			[ 'U', 'ᱩ' ],
			[ 'V', 'ᱶ' ],
			[ 'W', 'ᱣ' ],
			[ 'X', 'ᱽ' ],
			[ 'Y', 'ᱭ' ],
			[ 'Z', 'ᱼ' ],
			[ '\\.', 'ᱹ' ],
			[ '\\;', ';' ],
			[ '\\:', 'ᱺ' ],

			[ '0', '᱐' ],
			[ '1', '᱑' ],
			[ '2', '᱒' ],
			[ '3', '᱓' ],
			[ '4', '᱔' ],
			[ '5', '᱕' ],
			[ '6', '᱖' ],
			[ '7', '᱗' ],
			[ '8', '᱘' ],
			[ '9', '᱙' ]
		]
	};
	$.ime.register( satSarjomBaha );

}( jQuery ) );
