( function ( $ ) {
	'use strict';

	var lrcKbd = {
		id: 'lrc-kbd',
		name: 'لۊری شومالی',
		description: 'Northern Luri Keyboard Layout',
		date: '2015-05-11',
		URL: 'https://www.mediawiki.org/wiki/Special:MyLanguage/Help:Extension:UniversalLanguageSelector/Input_methods/lrc-kbd',
		author: 'Mjbmr',
		license: 'GPLv3',
		version: '1.0',
		patterns: [
			[ '`', '\u200c' ],
			[ '1', '۱' ],
			[ '2', '۲' ],
			[ '3', '۳' ],
			[ '4', '۴' ],
			[ '5', '۵' ],
			[ '6', '۶' ],
			[ '7', '۷' ],
			[ '8', '۸' ],
			[ '9', '۹' ],
			[ '0', '۰' ],

			[ 'q', 'ض' ],
			[ 'w', 'ص' ],
			[ 'e', 'ث' ],
			[ 'r', 'ق' ],
			[ 't', 'ف' ],
			[ 'y', 'غ' ],
			[ 'u', 'ع' ],
			[ 'i', 'ھ' ],
			[ 'o', 'خ' ],
			[ 'p', 'ح' ],
			[ '\\[', 'ج' ],
			[ '\\]', 'چ' ],

			[ 'a', 'ش' ],
			[ 's', 'س' ],
			[ 'd', 'ی' ],
			[ 'f', 'ب' ],
			[ 'g', 'ل' ],
			[ 'h', 'ا' ],
			[ 'j', 'ت' ],
			[ 'k', 'ن' ],
			[ 'l', 'م' ],
			[ ';', 'ک' ],
			[ '\'', 'گ' ],

			[ 'z', 'ظ' ],
			[ 'x', 'ط' ],
			[ 'c', 'ز' ],
			[ 'v', 'ر' ],
			[ 'b', 'ذ' ],
			[ 'n', 'د' ],
			[ 'm', 'پ' ],
			[ ',', 'ڤ' ],

			[ '~', '÷' ],
			[ '@', '٬' ],
			[ '#', '٫' ],
			[ '%', '٪' ],
			[ '\\^', '×' ],
			[ '&', '،' ],
			[ '\\(', ')' ],
			[ '\\)', '(' ],
			[ '_', 'ـ' ],

			[ 'Q', 'ۊ' ],
			[ 'W', 'ۉ' ],
			[ 'E', 'وٙ' ],
			[ 'R', 'ً' ],
			[ 'T', 'و' ],
			[ 'Y', 'أ' ],
			[ 'U', 'ە' ],
			[ 'I', 'ؤ' ],
			[ 'O', ']' ],
			[ 'P', '[' ],
			[ '\\{', '}' ],
			[ '\\}', '{' ],

			[ 'A', 'اٛ' ],
			[ 'S', 'ئ' ],
			[ 'D', 'ئو' ],
			[ 'F', 'ئی' ],
			[ 'G', 'لٛ' ],
			[ 'H', 'آ' ],
			[ 'J', 'او' ],
			[ 'K', '»' ],
			[ 'L', '«' ],
			[ '"', '؛' ],

			[ 'Z', 'نٛ' ],
			[ 'X', 'گٛ' ],
			[ 'C', 'ژ' ],
			[ 'V', 'ؽ' ],
			[ 'B', 'دٙ' ],
			[ 'N', 'ٔ' ],
			[ 'M', 'ء' ],
			[ '<', '>' ],
			[ '>', '<' ],
			[ '\\?', '؟' ]
		]
	};

	$.ime.register( lrcKbd );
}( jQuery ) );
