( function ( $ ) {
	'use strict';

	var shn = {
		id: 'shn-standard',
		name: 'တႆး',
		description: 'Shan Standard Keyboard per SIIT',
		date: '2022-09-15',
		URL: 'https://www.mediawiki.org/wiki/Special:MyLanguage/Help:Extension:UniversalLanguageSelector/Input_methods/shan-standard-keyboard',
		author: 'SIIT',
		license: 'GPLv3',
		version: '1.0',
		patterns: [
			// Basic Cosonants
			[ 'u', '', 'ၵ' ],
			[ 'c', '', 'ၶ' ],
			[ 'C', '', 'ꧠ' ],
			[ 'i', '', 'င' ],
			[ 'p', '', 'ႁ' ],
			[ 'q', '', 'ၸ' ],
			[ 'Z', '', 'ၾ' ],
			[ 'Q', '', 'ꩡ' ],
			[ 'n', '', 'ၺ' ],
			[ 'N', '', '႟' ],
			[ 'X', '', 'ꩪ' ],
			[ 'P', '', 'ႀ' ],
			[ 'w', '', 'တ' ],
			[ 'x', '', 'ထ' ],
			[ 'e', '', 'ၼ' ],
			[ 'y', '', 'ပ' ],
			[ 'z', '', 'ၽ' ],
			[ 'u', '', 'ၵ' ],
			[ 'U', '', 'ၷ' ],
			[ 'b', '', 'ယ' ],
			[ 'r', '', 'မ' ],
			[ 'B', '', 'ျ' ],
			[ '&', '', '&' ],
			[ 'v', '', 'လ' ],
			[ 'W', '', 'ၻ' ],
			[ 'o', '', '\u101D' ],
			[ 'E', '', 'ꧣ' ],
			[ 'Y', '', 'ၿ' ],
			[ 'V', '', 'ꩮ' ],
			[ 't', '', 'ဢ' ],
			[ 'I', '', 'ရ' ],
			[ 'O', '', 'သ' ],

			// Signs
			[ 'm', '', 'ၢ' ],
			[ 'g', '', 'ွ' ],
			[ 'd', '', 'ိ' ],
			[ 'D', '', 'ီ' ],
			[ 'k', '', 'ု' ],
			[ 'l', '', 'ူ' ],
			[ 'a', '', 'ေ' ],
			[ 'J', '', 'ႆ' ],
			[ 'H', '', 'ံ' ],
			[ 'h', '', 'ႉ' ],
			[ '\\;', '', 'ႈ' ],
			[ 'f', '','်' ],
			[ 'F', '','ႂ်' ],
			[ 'M', '', 'ႃ' ],

			// Punctuation
			[ '\\>', '', '။' ],
			[ '\\<', '', '၊' ],

			// Signs
			[ 'A', '', 'ဵ' ],
			[ 'K', '', 'ꧦ' ],
			[ 'L', '', 'ႊ' ],
			[ '\\#', '', '#' ],
			[ '\\~', '', '~' ],
			[ '\\!', '', '!' ],
			[ '\\:', '', 'း' ],
			[ 's', '', 'ႄ' ],
			[ 'j', '', 'ႇ' ],
			[ 'G', '', 'ႂ' ],
			[ 'S', '', 'ႅ' ],
			[ 'R', '', '႞' ],
			[ 'T', '', 'ြ' ],
			[ '\\{', '', '{' ],
			[ '\\]', '', ']' ],
			[ '\\[','', '[' ],
			[ '\\}', '', '}' ],
			[ '\\\\', '', '\'' ],

			// Shan digits, as jquery.ime doesn't support Alt+Key,
			// Shift+ALt+Key, Tide Key+Key will use Roman Digit only for now
			[ '0', '', '0' ],
			[ '1', '', '1' ],
			[ '2', '', '2' ],
			[ '3', '', '3' ],
			[ '4', '', '4' ],
			[ '5', '', '5' ],
			[ '6', '', '6' ],
			[ '7', '', '7' ],
			[ '8', '', '8' ],
			[ '9', '', '9' ]
		]
	};

	$.ime.register( shn );
}( jQuery ) );
