( function ( $ ) {
	'use strict';

	var ruPhonetic = {
		id: 'ru-phonetic',
		name: 'Russian phonetic',
		description: 'Russian phonetic keyboard layout',
		date: '2013-02-12',
		URL: 'https://www.mediawiki.org/wiki/Special:MyLanguage/Help:Extension:UniversalLanguageSelector/Input_methods/ru-phonetic',
		author: 'Parag Nemade',
		license: 'GPLv3',
		version: '1.0',
		patterns: [
			[ '\\#', 'ё' ],
			[ '\\$', 'Ё' ],
			[ '\\%', 'ъ' ],
			[ '\\^', 'Ъ' ],
			[ '\\=', 'ч' ],
			[ '\\+', 'Ч' ],
			[ '`', 'ю' ],
			[ '\\~', 'Ю' ],
			[ 'q', 'я' ],
			[ 'Q', 'Я' ],
			[ 'w', 'в' ],
			[ 'W', 'В' ],
			[ 'e', 'е' ],
			[ 'E', 'Е' ],
			[ 'r', 'р' ],
			[ 'R', 'Р' ],
			[ 't', 'т' ],
			[ 'T', 'Т' ],
			[ 'y', 'ы' ],
			[ 'Y', 'Ы' ],
			[ 'u', 'у' ],
			[ 'U', 'У' ],
			[ 'i', 'и' ],
			[ 'I', 'И' ],
			[ 'o', 'о' ],
			[ 'O', 'О' ],
			[ 'p', 'п' ],
			[ 'P', 'П' ],
			[ '\\[', 'ш' ],
			[ '\\{', 'Ш' ],
			[ '\\]', 'щ' ],
			[ '\\}', 'Щ' ],
			[ 'a', 'а' ],
			[ 'A', 'А' ],
			[ 's', 'с' ],
			[ 'S', 'С' ],
			[ 'd', 'д' ],
			[ 'D', 'Д' ],
			[ 'f', 'ф' ],
			[ 'F', 'Ф' ],
			[ 'g', 'г' ],
			[ 'G', 'Г' ],
			[ 'h', 'х' ],
			[ 'H', 'Х' ],
			[ 'j', 'й' ],
			[ 'J', 'Й' ],
			[ 'k', 'к' ],
			[ 'K', 'К' ],
			[ 'l', 'л' ],
			[ 'L', 'Л' ],
			[ '\\\\', 'э' ],
			[ '\\|', 'Э' ],
			[ 'z', 'з' ],
			[ 'Z', 'З' ],
			[ 'x', 'ь' ],
			[ 'X', 'Ь' ],
			[ 'c', 'ц' ],
			[ 'C', 'Ц' ],
			[ 'v', 'ж' ],
			[ 'V', 'Ж' ],
			[ 'b', 'б' ],
			[ 'B', 'Б' ],
			[ 'n', 'н' ],
			[ 'N', 'Н' ],
			[ 'm', 'м' ],
			[ 'M', 'М' ] ]
	};

	$.ime.register( ruPhonetic );
}( jQuery ) );
